/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.config.data.CfgItemCartridge;
import frc.emul.config.data.CfgItemGameHacks;
import frc.emul.config.data.CfgItemGameInfo;
import frc.emul.config.data.CfgItemOverlay;
import frc.emul.config.data.CfgItemPeripheral;
import frc.emul.config.data.CfgItemRom;
import frc.emul.config.data.IUnique;
import frc.util.IStream;
import java.io.File;
import java.net.URL;

public class CfgItemGame
implements IUnique {
    public final CfgItemGameHacks hacks = new CfgItemGameHacks();
    public Persistence persistence = new Persistence();
    public Shininess shininess = new Shininess();
    public CfgItemOverlay overlay = new CfgItemOverlay();
    public CfgItemGameInfo info = new CfgItemGameInfo(this);
    public CfgItemPeripheral[] requirements;
    public CfgItemRom systemRom;
    public boolean systemRomDefault;
    public CfgItemCartridge cartridge;

    public CfgItemGame() {
        this(CfgItemCartridge.EMPTY);
    }

    public CfgItemGame(CfgItemCartridge cfgItemCartridge) {
        this.setCartridge(cfgItemCartridge);
    }

    public String toString() {
        return " " + this.cartridge.name + " ";
    }

    public String getID() {
        return this.cartridge.getID();
    }

    public String getName() {
        return this.cartridge.getName();
    }

    public boolean isDocAvailable() {
        return CfgItemCartridge.isNotBlank(this.info.docPath);
    }

    public boolean hasCartridge() {
        return this.cartridge.hasCartridge();
    }

    public boolean hasCartridgeRam() {
        return this.cartridge.hasCartridgeRam();
    }

    public boolean hasHacks() {
        return this.hacks.hasHack();
    }

    public boolean hasRequirements() {
        return this.requirements != null;
    }

    public boolean isZippedEntry() {
        return this.cartridge.isZippedEntry();
    }

    public IStream getCartridgeStream() {
        return this.cartridge.getCartridgeStream();
    }

    public void resetCartridgeStream() {
        this.cartridge.resetCartridgeStream();
    }

    public URL getDocURL() {
        try {
            return this.isDocAvailable() ? new File(this.info.docPath).toURL() : null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void setCartridge(CfgItemCartridge cfgItemCartridge) {
        this.cartridge = cfgItemCartridge;
    }

    public class Persistence {
        public boolean enabled = true;
        public int history = 20;
    }

    public class Shininess {
        public float normal = 2.0f;
        public float blurred = 1.5f;
    }
}

